




--                                        QUICK EDIT

--******************************************************************************************

melonmodel = "models/props_junk/watermelon01.mdl"
melonpower = 100000000
melon_health = "60"
melon_damaage = "explodedamage 100"
melon_radius = "exploderadius 200"

--******************************************************************************************














function onInit()
	_swepsetsound(myindex, "single_shot", "weapon_physcannon.launch")
end

function onThink()
end

function onPrimaryAttack()
	if (_PlayerInfo(Owner, "alive") == false) then return; end
	local melon = _EntCreate( "prop_physics" );
        iSmoke = _EntCreate( "env_smoketrail" );
	_EntPrecacheModel( melonmodel );
	_EntSetModel(melon, melonmodel);
	_EntSetPos(melon, vecAdd(_PlayerGetShootPos(Owner),vector3(0,0,0)))
	_EntSetAng(melon, _PlayerGetShootAng(Owner));
	_EntSetKeyValue(melon, "damage", "100");
	local power = melonpower;
	local fireforce = vecMul(_PlayerGetShootAng(Owner), vector3(power, power, power));
	_PhysSetMass(melon,50000);
        _EntSpawn(melon);
        _phys.EnableGravity(melon,false);
        _PhysSetMass(melon,50000);
	_PhysApplyForce(melon, fireforce);
	_SWEPUseAmmo(MyIndex, 0, 1);
	_EntFire(melon, "Sethealth", melon_health, " ");
	_EntFire(melon, "addoutput", melon_radius,0)
	_EntFire(melon, "addoutput", melon_damaage,0)
        _EntFire(melon, "ignite", " ", "0");
	_EntSetPos( iSmoke, _EntGetPos( melon ) );
	_EntSetKeyValue( iSmoke,"smokesprite","sprites/whitepuff.spr" )
	_EntSetKeyValue( iSmoke,"spawnradius",20 )
	_EntSetKeyValue( iSmoke,"endsize",30 )
	_EntSetKeyValue( iSmoke,"startcolor","225 225 225" )
	_EntSetKeyValue( iSmoke,"endcolor","255 255 255" )
	_EntSetKeyValue( iSmoke,"lifetime","5.0" )
	_EntSetKeyValue( iSmoke,"spawnrate","60" )
	_EntSetKeyValue( iSmoke,"opacity","0.90" )
	_EntSetParent( iSmoke,melon )
        _EntSpawn( iSmoke);
        _PlaySound ( "weapons/melon/baseball.wav" )

end

function onSecondaryAttack()	

		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
		
		local iBolt = _EntCreate( "rpg_missile" );
		
		if (iBolt > 0) then
			
			_EntSetKeyValue( iBolt, "damage", "100");
			_EntSetPos( iBolt, _PlayerGetShootPos( Owner ) );
			_EntSetAng( iBolt, _PlayerGetShootAng( Owner ) );
			_EntSetOwner( iBolt, Owner );
			
			local vVelocity = vecMul( _PlayerGetShootAng( Owner ), vector3(1500, 1500, 1500) );
			_EntSetVelocity( iBolt, vVelocity );
				
			_EntSpawn( iBolt );
			
		end	
	

end

function onReload( )
        return true;
end

function getWeaponSwapHands()
	return true;	
end

function getWeaponSlot()
	return 5;	
end

function getWeaponSlotPos()
	return 5;	
end

function getFiresUnderwater()
	return true;
end

function getReloadsSingly()
	return true;
end

function getPrimaryShotDelay()
	return 0.5;
end

function getSecondaryShotDelay()
	return 0.3;
end

function getPrimaryIsAutomatic()
	return true;
end

function getSecondaryIsAutomatic()
	return true;
end

function getPrimaryAmmoType()
	return "none";
end

function getSecondaryAmmoType()
	return "none";
end

function getMaxClipPrimary()
	return 500;
end

function getMaxClipSecondary()
	return -1;
end

function getDefClipPrimary()
	return 500;
end


function getDefClipSecondary()
	return -1;
end

function getViewKickRandom()
	return vector3( 3.0, 3.0, 3.0 );
end

function getViewModel( )
	return "models/weapons/v_shot_m3super90.mdl";
end

function getWorldModel( )
	return "models/weapons/w_shot_m3super90.mdl";
end

function getClassName()
	return "weapon_melonlauncher";
end

function getAnimPrefix()
	return "shotgun";
end

function getPrintName()
	return "melon-launcher";
end
